import React, {Component} from 'react';
import {Link, NavLink, withRouter} from 'react-router-dom';
import Route from 'route-parser';
import classNames from 'classnames';

const isFunction = value => typeof value === 'function';

const getPathTokens = pathname => {
    const paths = ['/'];

    if (pathname === '/') return paths;

    pathname.split('/').reduce((prev, curr) => {
        const currPath = `${prev}/${curr}`;
        paths.push(currPath);
        return currPath;
    });

    return paths;
};

function getRouteMatch(routes, path) {
    return Object.keys(routes)
        .map(key => {
            const params = new Route(key).match(path);
            return {
                didMatch: params !== false,
                params,
                key
            };
        })
        .filter(item => item.didMatch)[0];
}

function getBreadcrumbs({ routes, match, location }) {
    const pathTokens = getPathTokens(location.pathname);
    return pathTokens.map((path, i) => {
        const routeMatch = getRouteMatch(routes, path);
        if(!routeMatch) {
            return {name: "", path: path};
        }

        const routeValue = routes[routeMatch.key];
        const name = isFunction(routeValue)
            ? routeValue(routeMatch.params)
            : routeValue;
        return { name, path };
    });
}

function Breadcrumbs({ routes, match, location }) {
    const breadcrumbs = getBreadcrumbs({ routes, match, location });

    return (
        <div>
            {breadcrumbs.map((breadcrumb, i) => <span className="navbar-breadcrumb" key={breadcrumb.path}>
                <Link className={classNames({"navbar-breadcrumb-active": breadcrumb.path === location.pathname})} to={breadcrumb.path}>
                    {breadcrumb.name}
                </Link>
                <span style={{margin: "0 0.5em"}}>{i < breadcrumbs.length - 1 ? ' / ' : ''}</span>
                </span>)}
        </div>
    );
}

export default withRouter(Breadcrumbs);